<?php

// Set the maximum execution time of the script to 300 seconds (5 minutes)
set_time_limit(300);

function listFolderFiles($dir, $indent = 0, $maxDepth = 10, $currentDepth = 0)
{
    if (!is_dir($dir)) {
        echo str_repeat("&nbsp;", $indent) . "<span style='color:red;'>Failure or error: $dir</span><br>";
        return;
    }

    if ($currentDepth > $maxDepth) {
        return;
    }

    $ffs = @scandir($dir);
    if ($ffs === false) {
        echo str_repeat("&nbsp;", $indent) . "<span style='color:red;'>Failure or error: $dir</span><br>";
        return;
    }

    foreach ($ffs as $ff) {
        if ($ff != '.' && $ff != '..') {
            $path = $dir . '/' . $ff;
            if (is_dir($path)) {
                // Avoid certain directories known to be large
                if (in_array($ff, ['node_modules', 'vendor', 'cache'])) {
                    continue;
                }
                listFolderFiles($path, $indent + 4, $maxDepth, $currentDepth + 1);
            } else {
                $extension = pathinfo($path, PATHINFO_EXTENSION);
                if ($extension == 'zip' || $extension == 'apk') {
                    // Get the modification date and format it in the Brazilian format (DD/MM/YYYY)
                    $modificationDate = date("d/m/Y", filemtime($path));
                    echo str_repeat("&nbsp;", $indent) . "<span style='color:black;'>$path</span> - <span style='color:blue;'>$modificationDate</span><br>";
                }
            }
        }
    }
}

//listFolderFiles($_SERVER['DOCUMENT_ROOT']); // Adjust this path as needed

listFolderFiles('/'); // root directory

?>
