<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pelculas Populares</title>
    <!-- Incluir Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.3/css/all.min.css">
    <style>
        body {
            background-color: #1c1c1c;
            color: white;
            font-family: Arial, sans-serif;
        }

        .carousel-container {
            width: 70%;
            margin: 50px auto;
            overflow: hidden; /* Ocultar pelculas fuera del contenedor */
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
        }

        .movie-list {
            display: flex;
            transition: transform 0.5s ease; /* Desplazamiento suave */
        }

        .movie-container {
            text-align: center;
            min-width: 250px; /* Ancho ms grande para evitar recortes */
            margin: 0 20px;
        }

        .movie-image {
            width: 100%;
            height: 320px; /* Altura fija para mantener proporcin */
            object-fit: cover; /* Ajustar imagen dentro del contenedor */
            border-radius: 10px;
            margin-bottom: 10px;
        }

        .movie-title {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 10px;
        }

        .movie-rating {
            display: inline-block;
            font-size: 18px;
        }

        .movie-rating i {
            color: gold; /* Color de las estrellas */
            margin: 0 2px;
        }

        .movie-rating i.far {
            color: lightgray; /* Color para estrellas vacas */
        }
    </style>
</head>
<body>

    <div class="carousel-container">
        <div class="movie-list" id="movie-list">
            <!-- Las pelculas se cargarn aqu dinmicamente -->
        </div>
    </div>

    <script>
        const apiKey = '6b8e3eaa1a03ebb45642e9531d8a76d2'; // Reemplaza con tu API key de TMDb
        let currentPage = 1; // Comienza en la pgina 1
        let currentIndex = 0; // 01ndice para el carrusel

        // Funcin para obtener las pelculas populares de TMDb en espa09ol
        async function fetchPopularMovies() {
            try {
                const response = await fetch(`https://api.themoviedb.org/3/movie/popular?api_key=${apiKey}&language=es-ES&page=${currentPage}`);
                const data = await response.json();
                displayMovies(data.results);
                startCarousel(); // Iniciar el carrusel despus de cargar las pelculas
            } catch (error) {
                console.error('Error al obtener las pelculas populares:', error);
            }
        }

        // Funcin para mostrar las pelculas en la pgina
        function displayMovies(movies) {
            const movieList = document.getElementById('movie-list');
            movieList.innerHTML = ''; // Limpiar la lista antes de a09adir nuevos elementos

            movies.forEach(movie => {
                const movieContainer = document.createElement('div');
                movieContainer.classList.add('movie-container');

                const movieImage = document.createElement('img');
                movieImage.src = `https://image.tmdb.org/t/p/w500${movie.poster_path}`;
                movieImage.alt = `Poster de ${movie.title}`;
                movieImage.classList.add('movie-image');

                const movieTitle = document.createElement('h2');
                movieTitle.classList.add('movie-title');
                movieTitle.textContent = `${movie.title} (${new Date(movie.release_date).getFullYear()})`;

                const movieRating = document.createElement('div');
                movieRating.classList.add('movie-rating');

                const rating = Math.round(movie.vote_average / 2); // Convertir calificacin de 10 a 5 estrellas
                for (let i = 1; i <= 5; i++) {
                    const star = document.createElement('i');
                    if (i <= rating) {
                        star.classList.add('fas', 'fa-star'); // Estrella llena
                    } else {
                        star.classList.add('far', 'fa-star'); // Estrella vaca
                    }
                    movieRating.appendChild(star);
                }

                movieContainer.appendChild(movieImage);
                movieContainer.appendChild(movieTitle);
                movieContainer.appendChild(movieRating);
                movieList.appendChild(movieContainer);
            });
        }

        // Funcin para iniciar el carrusel automtico
        function startCarousel() {
            const movieList = document.getElementById('movie-list');
            const movieItems = document.querySelectorAll('.movie-container');
            const totalMovies = movieItems.length;
            
            setInterval(() => {
                currentIndex = (currentIndex + 1) % totalMovies; // Avanza al siguiente ndice

                // Desplazar el contenedor de la lista de pelculas
                movieList.style.transform = `translateX(${-currentIndex * 290}px)`; // Ajuste de 290px para nuevo ancho
            }, 3000); // Cambiar cada 3 segundos
        }

        // Llamar a la funcin para obtener y mostrar las pelculas populares
        fetchPopularMovies();
    </script>

</body>
</html>
